set scheme s2color
set more off

foreach dataset in apis ndhs {
	global dataset `dataset'
	
		global bandwidth 5
		
		global controls 
	
		use "$data\/${dataset}file", clear
		if "$dataset"=="apis" {
			drop id
		}	
		rename hhid id


		keep if inrange(age,60-$bandwidth,60+$bandwidth-1)
		set seed 2038947
		/**Corresponds to AT
		g categ=1 if (age<60|yr==0) & phicmem==1
		**Corresponds to AT+TC
		replace categ=2 if age>=60 & phicmem==1 & yr==1
		**Corresponds to NT+UC
		replace categ=3 if (age<60|yr==0) & phicmem==0
		**Corresponds to NT 
		replace categ=4 if age>=60 & phicmem==0 & yr==1
		label define categ 1 "AlwaysTakers"  2 "AT+TComp" 3 "NT+UComp" 4 "NeverTakers"
		label values categ "categ"
		*/
		fvset base 4 categ
		*saves temporary master data set
		save temp.dta, replace
		local outcomes male dhgc_1 dhgc_2 dhgc_3 dincg_1 dincg_2 dincg_3  /*lnpchealth mvisit yconfined */

		global dhgc_1label "A. Low Education"
		global dhgc_2label "B. Middle Education"
		global dhgc_3label "C. High Education"
		global dincg_1label "D. Low SES"
		global dincg_2label "E. Middle SES"
		global dincg_3label "F. High SES"
		global malelabel "G. Male"

		local REPS = 1000
		**for pi
		local REPS0 = 100 
		set matsize `REPS'
		**col 1 = mu0
		local mu0 = 1
		**col 2 = mu1
		local mu1 = 2
		**col 3 = average of compliers
		local C = 3
		**col 4 = unconditional mean
		local unc = 4
		**Note that AT and NT are both macros and scalars that mean different things (just to confuse you)
		**col 5 = always takers
		local AT = 5
		**col 6 = never takers takers
		local NT = 6

		foreach var in `outcomes' {
			matrix define MU_`var' = J(`REPS',6,0)
			matrix define MU_pi_`var' = J(`REPS0',2,0)
		}

		**Constructs the optimal pi
		qui {
		forvalues i = 1/`REPS0' {
			use temp, clear
			bsample
			**Computing the propensity score pre and post age 60
			qui reg phicmem i.D##year i.D##c.X1 if inrange(X1, - $bandwidth , $bandwidth -1), cluster(id)
			predict p1 if (X1 >= 0 & X1 <= 1) & yr==1
			qui sum p1
			local p1 = r(mean)
			predict p0 if (X1 <= -1 & X1 >= -2) & yr==1
			qui sum p0
			local p0 = r(mean)
			estimates clear
			foreach var in `outcomes' {
				qui reg `var' i.categ $controls, cluster(id)
				qui scalar AT = _b[1.categ]
				qui scalar ATTC = _b[2.categ]
				qui scalar NTUC = _b[3.categ]
				qui scalar NT = _b[_cons]
				qui scalar define mu_`var'_0 = (1/(`p1'-`p0'))*((1-`p0')*(NT + NTUC) - (1-`p1')*NT)
				qui scalar list mu_`var'_0
				matrix MU_pi_`var'[`i',`mu0'] = mu_`var'_0
				qui scalar define mu_`var'_1 = (1/(`p1'-`p0'))*(`p1'*(NT + ATTC) - `p0'*(NT+AT))
				qui scalar list mu_`var'_1
				matrix MU_pi_`var'[`i',`mu1'] = mu_`var'_1
			}
			drop p1 p0
			disp `i'
		}

		matrix define PI = J(1,7,0)
		local i = 1
		foreach var in `outcomes' {
			svmat MU_pi_`var'
			qui cor MU_pi_`var'*, c
			scalar define V_0 = r(Var_1)
			scalar define V_1 = r(Var_2)
			scalar define C = r(cov_12)
			matrix PI[1,`i'] = (V_1 - C)/(V_0 + V_1 - 2*C)
			local i = `i' + 1
			disp `i'
		}

		forvalues i = 1/`REPS' {
			use temp, clear
			bsample
			**Computing the propensity score pre and post age 60
			qui reg phicmem i.D##year i.D##c.X1 if inrange(X1, - $bandwidth , $bandwidth -1), cluster(id)
			predict p1 if (X1 >= 0 & X1 <= 1) & yr==1
			qui sum p1
			local p1 = r(mean)
			predict p0 if (X1 <= -1 & X1 >= -2) & yr==1
			qui sum p0
			local p0 = r(mean)
			qui sum phicmem
			**This is the unconditional probablity of treatment
			*local pd = r(mean)
			*disp `pd_comp'
			estimates clear
			local j = 1
			foreach var in `outcomes' {
				local pi = PI[1,`j']
				qui sum `var'
				matrix MU_`var'[`i',`unc'] = r(mean)
				qui reg `var' i.categ $controls , cluster(id)
				qui scalar AT = _b[1.categ]
				qui scalar ATTC = _b[2.categ]
				qui scalar NTUC = _b[3.categ]
				qui scalar NT = _b[_cons]
				qui scalar define mu_`var'_0 = (1/(`p1'-`p0'))*((1-`p0')*(NT + NTUC) - (1-`p1')*NT)
				qui scalar list mu_`var'_0
				*local x = (1-`p1')/(1-`pd')
				matrix MU_`var'[`i',`mu0'] = mu_`var'_0
				qui scalar define mu_`var'_1 = (1/(`p1'-`p0'))*(`p1'*(NT + ATTC) - `p0'*(NT+AT))
				qui scalar list mu_`var'_1
				matrix MU_`var'[`i',`mu1'] = mu_`var'_1
				matrix MU_`var'[`i',`C'] = mu_`var'_1*`pi'+mu_`var'_0*(1-`pi')
				matrix MU_`var'[`i',`AT'] = NT + AT
				matrix MU_`var'[`i',`NT'] = NT
				local j = `j' + 1
			}
			drop p1 p0
			disp `i'
		}
		}
		clear
		foreach var in `outcomes' {
			svmat MU_`var', name(`var')
			rename `var'`mu0' mu_`var'_0 //eqn 3
			rename `var'`mu1' mu_`var'_1 //eqn 4
			rename `var'`unc' mu_`var'_uncond
			rename `var'`C' mu_`var'_C
			rename `var'`AT' mu_`var'_AT
			rename `var'`NT' mu_`var'_NT
			gen diff_`var' = mu_`var'_1 - mu_`var'_0
			xtile diff_`var'_q = diff_`var', nq(`REPS')
			replace diff_`var'_q = (diff_`var'_q/`REPS')*100
			qui sum diff_`var' if diff_`var'_q >= 2 & diff_`var'_q <= 3
			local p025 = round(r(mean),0.001)
			qui sum diff_`var' if diff_`var'_q >= 97 & diff_`var'_q <= 98
			local p975 = round(r(mean),0.001)
			disp `p975'
			cap drop Q2_5 Q97_5 Mean xvar *_q
			gen Q2_5 = .
			gen Q97_5 = .
			gen Mean = .
			gen xvar = .
			local j = 1

			foreach xvar in mu_`var'_AT mu_`var'_C mu_`var'_NT mu_`var'_uncond {
				sum `xvar'
				replace Mean = r(mean) in `j'
				egen `xvar'_q = xtile(`xvar'), n(1000)
				sum `xvar' if `xvar'_q == 25
				local q2_5 = r(mean)
				replace Q2_5 = `q2_5' in `j' 
				
				sum `xvar' if `xvar'_q == 975
				local q97_5 = r(mean)
				replace Q97_5 = `q97_5' in `j' 
				
				replace xvar = `j' in `j'
				local ++j				
				
			}
			twoway (scatter Mean xvar) (rcap Q2_5 Q97_5 xvar), /// 
				xtitle(" ")   ///
				xlabel( 0.5 " " 1 `""Always" "Takers""' 2 "Compliers" 3 `""Never" "Takers""' 4 `""Unconditional" "Mean""' 4.5 " ",noticks)  ///
				legend(off) scheme(s2mono) graphregion(color(white)) saving(`var', replace) scale(*1.4)
				
			graph export "$figs\/${dataset}_box_plot_`var'.png", as(png) replace
		
			
			
		}
	
}
*dataset loop end